/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export;

import com.google.common.collect.Maps;
import cz.insophy.inplan.export.excel.ExcelTableWriter;
import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableWriter
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger(ExcelTableWriter.class);
    private final Map<String, List<String>> errors = Maps.newHashMap();

    public abstract boolean canWriteStatistics();

    public abstract void newSheet(String var1);

    public abstract boolean newRow();

    public abstract void newHeaderCell(String var1);

    public abstract void newStringCell(String var1, CellProperties var2);

    public abstract void newDateCell(Long var1, CellProperties var2);

    public abstract void newDatetimeCell(Long var1, CellProperties var2);

    public abstract void newTimeCell(Long var1, CellProperties var2);

    public abstract void newDurationInDayCell(Long var1, CellProperties var2);

    public abstract void newDurationInHourCell(Long var1, CellProperties var2);

    public abstract void newDurationCell(Long var1, CellProperties var2);

    public abstract void newBooleanCell(Boolean var1, CellProperties var2);

    public abstract void newIntegerCell(Long var1, CellProperties var2);

    public abstract void newFloatCell(Double var1, CellProperties var2);

    public abstract void newPercentCell(Double var1, CellProperties var2);

    public abstract void newColorCell(Color var1, CellProperties var2);

    public abstract void newEmptyCell(CellProperties var1);

    public abstract void addLink(@Nonnull String var1, @Nullable CellProperties var2);

    public abstract boolean addMultipleLinks(@Nonnull List<CellLink> var1);

    public abstract void addDescription(String var1, boolean var2);

    public abstract void addStatisticsFormula(ColumnStatisticsType var1);

    protected abstract void closeWriter() throws IOException;

    @Override
    public void close() throws IOException {
        this.logErrors();
        this.closeWriter();
    }

    public abstract void newNhCell(Long var1, CellProperties var2);

    protected void addError(@Nonnull String type, @Nonnull String message) {
        List strings = this.errors.computeIfAbsent(type, k -> new ArrayList());
        strings.add(message);
    }

    private void logErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        this.errors.keySet().forEach(key -> {
            List<String> strings = this.errors.get(key);
            log.warn(key + ": " + strings.get(0));
            if (strings.size() > 1) {
                log.warn("There was another {} errors of type {} while exporting table", (Object)(strings.size() - 1), key);
            }
        });
        this.errors.clear();
    }

    public static enum ColumnStatisticsType {
        NONE,
        SUM,
        AVG,
        MIN,
        MAX;

    }

    public record CellLink(@Nonnull String url, @Nullable String text) {
    }

    public static class CellProperties {
        public String bckgColor;
        public String txtColor;

        public CellProperties(String bckgColor, String txtColor) {
            this.bckgColor = bckgColor;
            this.txtColor = txtColor;
        }
    }
}

